#include <bits/stdc++.h>

#define pb push_back
#define MAXN 200010
#define LOGN 19

using namespace std;

int n;

class node {

public:
    int value;
    node *left, *right;
    node() {
        value = 0;
        left = right = nullptr;
    }
    node(int val) {
        value = val;
        left = right = nullptr;
    }
};

node *root[2 * MAXN];

void update(node *u, int l, int r, int x, int diff) {

    if(x < l || r < x)
        return;
    if(l == r) {
        u->value += diff;
        return;
    }

    if(u->left == nullptr)
        u->left = new node();
    if(u->right == nullptr)
        u->right = new node();

    int mid = (l + r) / 2;
    update(u->left, l, mid, x, diff);
    update(u->right, mid + 1, r, x, diff);
    u->value = u->left->value + u->right->value;
}

int get(node *u, int l, int r, int L, int R) {

    if(u == nullptr)
        return 0;
    if(L <= l && r <= R)
        return u->value;
    if(r < L || R < l)
        return 0;

    int mid = (l + r) / 2;
    return get(u->left, l, mid, L, R) + get(u->right, mid + 1, r, L, R);
}

int get1(int i, int l, int r, int L, int R, int L1, int R1) {

    if(L <= l && r <= R)
        return get(root[i], 0, n, L1, R1);
    if(r < L || R < l)
        return 0;

    int mid = (l + r) / 2;
    return get1(2 * i + 1, l, mid, L, R, L1, R1) + get1(2 * i + 2, mid + 1, r, L, R, L1, R1);
}

void update1(int i, int l, int r, int x, int x1, int diff) {

    if(x < l || r < x)
        return;
    if(l == r)
        update(root[i], 0, n, x1, diff);

    int mid = (l + r) / 2;
    update1(2 * i + 1, l, mid, x, x1, diff);
    update1(2 * i + 2, mid + 1, r, x, x1, diff);
}

vector<int> graph1[MAXN], graph2[MAXN];
int pos1[MAXN], pos2[MAXN];

void dfs1(int u, int p) {

    pos1[u] = 1;
    if(p != -1)
        pos1[u] += pos1[p];
    for(int v: graph1[u])
        if(v != p)
            dfs1(v, u);
}

void dfs2(int u, int p) {

    pos2[u] = 1;
    if(p != -1)
        pos2[u] += pos2[p];
    for(int v: graph2[u])
        if(v != p)
            dfs2(v, u);
}

void Resi(int N, int Q, int P, int *U1, int *V1, int *U2, int *V2, int *A1, int *B1, int *C1, int *D1, int *R) {

    for(int i = 1; i < N; i++) {
        graph1[U1[i]].pb(V1[i]); graph1[V1[i]].pb(U1[i]);
        graph2[U2[i]].pb(V2[i]); graph2[V2[i]].pb(U2[i]);
    }
    int cnt1 = 0, cnt2 = 0, u1, u2;
    for(int i = 1; i <= N; i++) {
        if(graph1[i].size() == 1) {
            cnt1++;
            u1 = i;
        }
        if(graph2[i].size() == 1) {
            cnt2++;
            u2 = i;
        }
    }
    if(N == 1 || (cnt1 == 2 && cnt2 == 2)) {
        dfs1(u1, -1);
        dfs2(u2, -1);
        n = N;

        for(int i = 1; i <= N; i++)
            update1(0, 0, N, pos1[i], pos2[i], 1);

        int res = 0;
        for(int i = 1; i <= Q; i++) {
            int a = (A1[i] + res * P - 1) % N + 1;
            int b = (B1[i] + res * P - 1) % N + 1;
            int c = (C1[i] + res * P - 1) % N + 1;
            int d = (D1[i] + res * P - 1) % N + 1;
            if(pos1[a] > pos1[b])
                swap(a, b);
            if(pos2[c] > pos2[d])
                swap(c, d);
            res = get1(0, 0, 2 * n, pos1[a], pos1[b], pos2[c], pos2[d]);
            R[i] = res;
        }
        return;
    }

    int res = 0;
    for(int i = 1; i <= Q; i++) {
        int a = (A1[i] + res * P - 1) % N + 1;
        int b = (B1[i] + res * P - 1) % N + 1;
        int c = (C1[i] + res * P - 1) % N + 1;
        int d = (D1[i] + res * P - 1) % N + 1;

        res = 0;
        R[i] = res;
    }
}

/*

5 4 0
1 2
2 3
3 4
4 5
2 1
1 4
4 3
3 5
1 2 1 2
1 3 2 3
1 5 1 5
2 3 5 2

*/